/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.perk;

import dev.toma.gunsrpg.common.perk.Perk;
import dev.toma.gunsrpg.util.ModUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.ResourceLocation;

public final class PerkRegistry {
    private static final PerkRegistry REGISTRY = new PerkRegistry();
    private final Random random = new Random();
    private final Map<ResourceLocation, Perk> perkMap = new HashMap<ResourceLocation, Perk>();
    private List<Perk> perkList;

    public static PerkRegistry getRegistry() {
        return REGISTRY;
    }

    public Perk getPerkById(ResourceLocation id) {
        return this.perkMap.get(id);
    }

    public void dropRegistry() {
        this.perkMap.clear();
    }

    public void register(ResourceLocation id, Perk perk) {
        perk.setId(id);
        this.perkMap.put(id, perk);
    }

    public void finishRegistering() {
        this.perkList = new ArrayList<Perk>(this.perkMap.values());
    }

    public Perk getRandomPerk() {
        return ModUtils.getRandomListElement(this.perkList, this.random);
    }

    public int size() {
        return this.perkMap.size();
    }

    public Set<ResourceLocation> getPerkIds() {
        return this.perkMap.keySet();
    }

    public Set<Perk> getPerks() {
        return new HashSet<Perk>(this.perkMap.values());
    }

    private PerkRegistry() {
    }
}

